<?php

defined('ABSPATH') || exit;

global $ulz_explore;

?>

<div class="ulz-modal-container ulz-scrollbar">

    <?php if( $ulz_explore->user->id && $ulz_explore->user->favorites ): ?>
        <div class="ulz-favorites-list">
            <ul>
                <?php foreach( array_reverse( $ulz_explore->user->favorites ) as $time => $listing_id ): ?>
                    <?php
                        $listing = new \UtillzCore\Inc\Src\Listing\Listing( $listing_id );
                        $image = $listing->get_first_from_gallery( 'thumbnail' );
                    ?>
                    <?php if( $listing->id ): ?>
                        <li>
                            <a href="<?php echo get_the_permalink( $listing->id ); ?>" class="ulz--image">
                                <?php if( $image ): ?>
                                    <img src="<?php echo esc_url( $image ); ?>" alt="">
                                <?php else: ?>
                                    <?php echo Ucore()->dummy( null, null, 100 ); ?>
                                <?php endif; ?>
                            </a>
                            <a href="#" class="ulz-remove" data-action="add-favorite" data-id="<?php echo $listing->id; ?>">
                                <i class="fas fa-trash-alt"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="ulz--icon<?php if( $ulz_explore->user->id && $ulz_explore->user->favorites ) { echo ' ulz-none'; } ?>">
        <i class="material-icons">sentiment_dissatisfied</i>
        <p><?php esc_html_e( 'No favorites were found', 'utillz-core' ); ?></p>
    </div>

</div>
